#include <p30fxxxx.h>
#include <spi.h>

/************************************************************************
*     Function Name :  ConfigIntSPI1                                    *
*     Description   :  This Function Configures Interrupt and sets      *
*                      Interrupt Priority                               *
*     Parameters    :  unsigned int config                              *
*     Return Value  :  None                                             *
*************************************************************************/

void ConfigIntSPI1( unsigned int config)
{
    IFS0bits.SPI1IF = 0;                   /* Clear IF bit  */
    IPC2bits.SPI1IP = (config &0x0007);    /* assign interrupt priority to 
                                             IPC register */

    IEC0bits.SPI1IE = (config &0x0008)>>3; /*Interrupt Enable/Disable bit 
                                             in IEC Register */
}
